/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.app;

import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.logo.app.ActionOwner;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.MDIMenuManager;
import DE.siemens.ad.logo.app.MenuManager;
import DE.siemens.ad.logo.app.Model;
import DE.siemens.ad.logo.app.SplittedView;
import DE.siemens.ad.logo.app.View;
import DE.siemens.ad.logo.app.action.ChangeToViewAction;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.app.LogoComfort;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;

public abstract class MDIManager
implements ActionOwner {
    protected Application fApplication;
    protected View fActiveTopLevelView;
    protected Vector fViews;
    public ApplicationSurface fApplicationSurface;

    public void addView(View v) {
        this.getViews().add(v);
        v.getEditor().setApplication(this.getApplication());
        v.getEditor().setApplicationSurface(this.getApplicationSurface());
        ChangeToViewAction changeToViewAction = new ChangeToViewAction();
        changeToViewAction.setOwner(this);
        changeToViewAction.setView(v);
        ((MDIMenuManager)this.getMenuManager()).getOpenViewsActionGroup().addAction(changeToViewAction);
    }

    public void changeToView(View view) {
        for (ChangeToViewAction changeToViewAction : ((MDIMenuManager)this.getMenuManager()).getOpenViewsActionGroup().getActions()) {
            if (changeToViewAction.getView() != view || changeToViewAction.isSelected()) continue;
            changeToViewAction.setSelected(true);
        }
    }

    public void cloneWindow() {
        View v = (View)this.getActiveTopLevelView().getEditor().getView().clone();
        LogoComfort comfort = new LogoComfort();
        comfort.newDocument();
        comfort.setActiveView((DrawingView)((Object)v));
        this.addView(v);
    }

    public void close() {
        this.fApplicationSurface.getWindow().removeWindowListener(this.getWindowEventHandler());
        this.fApplicationSurface.getWindow().dispose();
        LogoProperties props = LogoProperties.instance();
        if (this.getWindow() instanceof Frame) {
            if ((((Frame)this.getWindow()).getExtendedState() & 6) == 6) {
                props.setProperty("app.window.max", String.valueOf(true));
            } else {
                Rectangle r = this.getWindow().getBounds();
                props.setProperty("app.width", String.valueOf(r.getWidth()));
                props.setProperty("app.height", String.valueOf(r.getHeight()));
                props.setProperty("app.posX", String.valueOf(r.getX()));
                props.setProperty("app.posY", String.valueOf(r.getY()));
                props.setProperty("app.window.max", String.valueOf(false));
            }
        }
        this.fApplicationSurface.getWindowManager().saveWindowStates();
    }

    private void collectNestedViews(SplittedView splittedView, Vector nestedViews) {
        if (splittedView.getView1() instanceof SplittedView) {
            this.collectNestedViews((SplittedView)splittedView.getView1(), nestedViews);
        } else {
            nestedViews.add(splittedView.getView1());
        }
        if (splittedView.getView2() instanceof SplittedView) {
            this.collectNestedViews((SplittedView)splittedView.getView2(), nestedViews);
        } else {
            nestedViews.add(splittedView.getView2());
        }
    }

    public View getActiveTopLevelView() {
        return this.fActiveTopLevelView;
    }

    public Application getApplication() {
        return this.fApplication;
    }

    public ApplicationSurface getApplicationSurface() {
        return this.fApplicationSurface;
    }

    public abstract JComponent getMDIComponent(View var1);

    public abstract MenuManager getMenuManager();

    public abstract String getName();

    public abstract JComponent getPreviewPanel();

    public Collection getViews() {
        if (this.fViews == null) {
            this.fViews = new Vector();
        }
        return this.fViews;
    }

    public Collection getViews(Model model) {
        Iterator i = this.getViews().iterator();
        View v = null;
        Vector<View> views = new Vector<View>();
        while (i.hasNext()) {
            v = (View)i.next();
            if (v.getModel() != model) continue;
            views.add(v);
        }
        return views;
    }

    public Window getWindow() {
        return this.fApplication.getActiveApplicationSurface().getWindow();
    }

    public void open() {
        LogoProperties props = LogoProperties.instance();
        boolean isMaxSize = props.getBooleanProperty("app.window.max", false);
        String title = Application.getName();
        this.fApplicationSurface = new ApplicationSurface(this.fApplication, title);
        this.fApplicationSurface.setTitle(title);
        this.fApplicationSurface.getWindow().setName(title);
        this.fApplicationSurface.setIconImage(Application.getIconImage());
        this.fApplicationSurface.getWindow().addWindowListener(this.getWindowEventHandler());
        double posX = props.getDoubleProperty("app.posX", 60.0);
        double posY = props.getDoubleProperty("app.posY", 30.0);
        double width = props.getDoubleProperty("app.width", 700.0);
        double height = props.getDoubleProperty("app.height", 500.0);
        if (posX + width <= 10.0) {
            posX = 0.0;
            width = 720.0;
        }
        if (posY + height <= 10.0) {
            posY = 0.0;
            height = 540.0;
        }
        this.fApplicationSurface.getWindow().setBounds(new Rectangle((int)posX, (int)posY, (int)width, (int)height));
        if (isMaxSize && this.fApplicationSurface.getWindow() instanceof Frame) {
            int preState = ((Frame)this.fApplicationSurface.getWindow()).getExtendedState();
            ((Frame)this.fApplicationSurface.getWindow()).setExtendedState(preState | 6);
        }
        this.fApplicationSurface.getWindow().setVisible(true);
        System.out.println(this.fApplicationSurface.getWindow().getBounds());
    }

    protected abstract WindowListener getWindowEventHandler();

    public void removeView(View view) {
        this.getViews().remove(view);
        if (this.fActiveTopLevelView == view) {
            this.fActiveTopLevelView = null;
        }
        MDIMenuManager menuManager = (MDIMenuManager)this.getMenuManager();
        ChangeToViewAction changeToViewAction = null;
        Iterator changeToViewActions = menuManager.getOpenViewsActionGroup().getActions().iterator();
        while (changeToViewActions.hasNext() && (changeToViewAction = (ChangeToViewAction)changeToViewActions.next()).getView() != view) {
        }
        if (changeToViewAction.getView() != view) {
            // empty if block
        }
        view.getModel().removeModelFileListener(changeToViewAction);
        menuManager.getOpenViewsActionGroup().removeAction(changeToViewAction);
    }

    public abstract void replaceTopLevelView(View var1, View var2);

    public void setApplication(Application newApplication) {
        this.fApplication = newApplication;
    }

    public void splitView(int orientation) {
        View activeView = this.fActiveTopLevelView.getEditor().getView();
        JComponent parent = (JComponent)activeView.getViewComponent().getParent();
        parent.remove(activeView.getViewComponent());
        SplittedView splittedView = new SplittedView(activeView, orientation);
        parent.add(splittedView.getViewComponent());
        if (this.fActiveTopLevelView == activeView) {
            this.replaceTopLevelView(this.fActiveTopLevelView, splittedView);
        } else {
            SplittedView viewParent = ((SplittedView)this.fActiveTopLevelView).findViewContainer(activeView);
            viewParent.replaceView(activeView, splittedView);
        }
        splittedView.getViewComponent().invalidate();
        parent.validate();
        parent.repaint();
        splittedView.centerDivider();
    }

    public void unsplitView() {
        if (!(this.getActiveTopLevelView() instanceof SplittedView)) {
            return;
        }
        Editor editor = this.getActiveTopLevelView().getEditor();
        View activeView = editor.getView();
        Vector nestedViews = new Vector();
        this.collectNestedViews((SplittedView)this.getActiveTopLevelView(), nestedViews);
        nestedViews.remove(activeView);
        editor.getViews().removeAll(nestedViews);
        Container parentComponent = this.getActiveTopLevelView().getViewComponent().getParent();
        this.replaceTopLevelView(this.fActiveTopLevelView, activeView);
        parentComponent.removeAll();
        parentComponent.add(activeView.getViewComponent());
        parentComponent.validate();
        parentComponent.repaint();
    }

    public abstract void updateSimulatedViewTitle(View var1);

    public abstract void updateViewTitle(File var1, File var2);
}

